/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.core.DataResponse;
import com.vcarecity.telnb.core.ErrorResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public final class ResponseHandleUtil {
    private static ObjectMapper objectMapper;

    public static AbstractResponse newErrorResponse(int httpCode, int status, String message) {
        DataResponse dataResponse = new DataResponse();
        dataResponse.setHttpCode(httpCode);
        dataResponse.setStatus(status);
        dataResponse.setMessage(message);
        return dataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static AbstractResponse responseDataHandler(ResponseEntity<String> response, Class<? extends IResponseDataContext> responseDataClazz) {
        JsonNode node;
        if (objectMapper == null) {
            Class<ResponseHandleUtil> clazz = ResponseHandleUtil.class;
            // MONITORENTER : com.vcarecity.telnb.util.ResponseHandleUtil.class
            if (objectMapper == null) {
                objectMapper = new ObjectMapper();
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }
            // MONITOREXIT : clazz
        }
        if (response.getStatusCode() == HttpStatus.NO_CONTENT) {
            DataResponse dataResponse = new DataResponse();
            dataResponse.setStatus(20000);
            dataResponse.setHttpCode(HttpStatus.NO_CONTENT.value());
            dataResponse.setStatus(20000);
            return dataResponse;
        }
        String body = (String)response.getBody();
        try {
            node = objectMapper.readTree(body);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseHandleUtil.newErrorResponse(response.getStatusCodeValue(), 40006, e.getMessage());
        }
        JsonNode errorCode = node.get("error_code");
        JsonNode errorDesp = node.get("error_desc");
        if (errorCode != null) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setHttpCode(response.getStatusCodeValue());
            errorResponse.setErrorCode(errorCode.asInt());
            errorResponse.setErrorDesc(errorDesp != null ? errorDesp.textValue() : null);
            return errorResponse;
        }
        DataResponse<IResponseDataContext> dataResponse = new DataResponse<IResponseDataContext>();
        dataResponse.setHttpCode(response.getStatusCodeValue());
        try {
            IResponseDataContext dataContext = (IResponseDataContext)objectMapper.readValue(body, responseDataClazz);
            dataResponse.setData(dataContext);
            dataResponse.setStatus(20000);
            return dataResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            dataResponse.setMessage(e.getMessage());
            dataResponse.setStatus(40006);
        }
        return dataResponse;
    }
}

