package com.vcarecity.allcommon.util;

public class BitUtil {
	/**
	 * 获取 整数 num 的第 i 位的值
	 * @param num
	 * @param i
	 * @return
	 */
	public static boolean getBit(int num, int i) {
		return ((num & (1 << i)) != 0);// true 表示第i位为1,否则为0
	}

	/**
	 * 获取 整数 num 的第 i 位的值
	 * @param num
	 * @param i
	 * @return
	 */
	public static int getBit(byte num, int i) {
		return ((num & (1 << i)) != 0)?1:0;// true 表示第i位为1,否则为0
	}

	/**
	 * 将 整数 num 的第 i 位的值 置为 1
	 * @param num
	 * @param i
	 * @return
	 */
	public static int setBit1(int num, int i) {
		return (num | (1 << i));
	}

	/**
	 * 将 整数 num 的第 i 位的值 置为 0
	 * @param num
	 * @param i
	 * @return
	 */
	public static int setBit0(int num, int i) {
		int mask = ~(1 << i);// 000100
		return (num & (mask));// 111011
	}

	/**
	 * 将 整数 num 的第 i 位的值 置为 1
	 * @param num
	 * @param i
	 * @return
	 */
	public static byte setBit1(byte num, int i) {
		return (byte)(num | (1 << i));
	}

	/**
	 * 将 整数 num 的第 i 位的值 置为 0
	 * @param num
	 * @param i
	 * @return
	 */
	public static byte setBit0(byte num, int i) {
		int mask = ~(1 << i);// 000100
		return (byte)(num & (mask));// 111011
	}

	/**
	 * 将字节的位置设置为指定的0或1
	 * @param num 要转换的字节或数字
	 * @param i 右起第几位
	 * @param ZeroOrOne 0或1
	 * @return
	 */
	public static byte setBit(byte num, int i,String ZeroOrOne) {
		byte bt;
		if("1".equalsIgnoreCase(ZeroOrOne)){
			bt=setBit1(num,i);
		}else{
			bt=setBit0(num,i);
		}
		return bt;
	}
	/**
	 * 将字节的位置设置为指定的0或1
	 * @param num 要转换的字节或数字
	 * @param i 右起第几位
	 * @param ZeroOrOne 0或1
	 * @return
	 */
	public static byte setBit(byte num, int i,int ZeroOrOne) {
		byte bt;
		if(1==ZeroOrOne){
			bt=setBit1(num,i);
		}else{
			bt=setBit0(num,i);
		}
		return bt;
	}
	/**
	 * 转换成8位长度的二进制字符串
	 *
	 * @param b
	 * @return
	 */
	public static String byteToBinaryString(byte b) {
		return String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
	}

	/**
	 * 翻转字符器
	 *
	 * @param data
	 * @return
	 */
	public static String reverseString(String data) {
		return new StringBuilder(data).reverse().toString();
	}

	/**
	 * 获得指定字节中从左边数起的第几位是0还是1，位置范围 0-7
	 * @param data 待判断的字节
	 * @param bitpos 位置范围 0-7
	 * @return
	 */
	public static char getByteBitFromLeft(byte data,int bitpos) {
		String bin = byteToBinaryString(data);
		return bin.charAt(bitpos);
	}

	/**
	 * 获得指定字节中从右边数起的第几位是0还是1，位置范围 0-7
	 * @param data 待判断的字节
	 * @param bitpos 位置范围 0-7
	 * @return
	 */
	public static char getByteBitFromRigth(byte data,int bitpos) {
		String bin = reverseString(byteToBinaryString(data));
		return bin.charAt(bitpos);
	}

	public static void main(String[] args) {
		byte bty=(byte)0x02;
		System.out.println("byteToBinaryString:"+byteToBinaryString(bty));
		System.out.println("getBit:"+getBit(bty,1));
		System.out.println("byteToBinaryString:"+byteToBinaryString(bty));
		bty=setBit1(bty,3);
		System.out.println("setBit1:"+bty);
		System.out.println("byteToBinaryString:"+byteToBinaryString(bty));
		bty=setBit1(bty,0);
		System.out.println("setBit1:"+bty);
		System.out.println("byteToBinaryString:"+byteToBinaryString(bty));
	}
}
