package com.vcarecity.allcommon.util;

import com.vcarecity.allcommon.exception.DecoderException;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/**
 * @author Kerry on 18/10/11
 */

public final class HexUtil {


    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];


    public static byte[] checkByteArrayLen(byte[] data, int len) {
        if (data.length == len) {
            return data;
        } else if (data.length > len) {
            return Arrays.copyOf(data, len);
        }
        byte[] temp = new byte[len];
        System.arraycopy(data, 0, temp, 0, data.length);
        return temp;
    }


    /**
     * byte[] 转换 int字符串
     *
     * @param data
     * @return
     */
    public static String byteArrayToIntToString(byte[] data) {
        return String.valueOf(HexUtil.byteArrayToInt(data));
    }

    /**
     * 将int转为高字节在前，低字节在后的byte数组（大端）
     * @param n int
     * @return byte[]
     */
    public static byte[] intToByteBig(int n) {
        byte[] b = new byte[4];
        b[3] = (byte) (n & 0xff);
        b[2] = (byte) (n >> 8 & 0xff);
        b[1] = (byte) (n >> 16 & 0xff);
        b[0] = (byte) (n >> 24 & 0xff);
        return b;
    }
    /**
     * 将int转为低字节在前，高字节在后的byte数组（小端）
     * @param n int
     * @return byte[]
     */
    public static byte[] intToByteLittle(int n) {
        byte[] b = new byte[4];
        b[0] = (byte) (n & 0xff);
        b[1] = (byte) (n >> 8 & 0xff);
        b[2] = (byte) (n >> 16 & 0xff);
        b[3] = (byte) (n >> 24 & 0xff);
        return b;
    }
    /**
     * byte数组到int的转换(小端)
     * @param bytes
     * @return
     */
    public static int bytes2IntLittle(byte[] bytes )
    {
        int int1=bytes[0]&0xff;
        int int2=(bytes[1]&0xff)<<8;
        int int3=(bytes[2]&0xff)<<16;
        int int4=(bytes[3]&0xff)<<24;

        return int1|int2|int3|int4;
    }
    /**
     * byte数组到int的转换(大端)
     * @param bytes
     * @return
     */
    public static int bytes2IntBig(byte[] bytes )
    {
        int int1=bytes[3]&0xff;
        int int2=(bytes[2]&0xff)<<8;
        int int3=(bytes[1]&0xff)<<16;
        int int4=(bytes[0]&0xff)<<24;

        return int1|int2|int3|int4;
    }
    /**
     * 将short转为高字节在前，低字节在后的byte数组（大端）
     * @param n short
     * @return byte[]
     */
    public static byte[] shortToByteBig(short n) {
        byte[] b = new byte[2];
        b[1] = (byte) (n & 0xff);
        b[0] = (byte) (n >> 8 & 0xff);
        return b;
    }

    /**
     * 将short转为低字节在前，高字节在后的byte数组(小端)
     * @param n short
     * @return byte[]
     */
    public static byte[] shortToByteLittle(short n) {
        byte[] b = new byte[2];
        b[0] = (byte) (n & 0xff);
        b[1] = (byte) (n >> 8 & 0xff);
        return b;
    }
    /**
     *  读取小端byte数组为short
     * @param b
     * @return
     */
    public static short byteToShortLittle(byte[] b) {
        return (short) (((b[1] << 8) | b[0] & 0xff));
    }
    /**
     *  读取大端byte数组为short
     * @param b
     * @return
     */
    public static short byteToShortBig(byte[] b) {
        return (short) (((b[0] << 8) | b[1] & 0xff));
    }
    /**
     * long类型转byte[] (大端)
     * @param n
     * @return
     */
    public static byte[] longToBytesBig(long n) {
        byte[] b = new byte[8];
        b[7] = (byte) (n & 0xff);
        b[6] = (byte) (n >> 8  & 0xff);
        b[5] = (byte) (n >> 16 & 0xff);
        b[4] = (byte) (n >> 24 & 0xff);
        b[3] = (byte) (n >> 32 & 0xff);
        b[2] = (byte) (n >> 40 & 0xff);
        b[1] = (byte) (n >> 48 & 0xff);
        b[0] = (byte) (n >> 56 & 0xff);
        return b;
    }
    /**
     * long类型转byte[] (小端)
     * @param n
     * @return
     */
    public static byte[] longToBytesLittle(long n) {
        byte[] b = new byte[8];
        b[0] = (byte) (n & 0xff);
        b[1] = (byte) (n >> 8  & 0xff);
        b[2] = (byte) (n >> 16 & 0xff);
        b[3] = (byte) (n >> 24 & 0xff);
        b[4] = (byte) (n >> 32 & 0xff);
        b[5] = (byte) (n >> 40 & 0xff);
        b[6] = (byte) (n >> 48 & 0xff);
        b[7] = (byte) (n >> 56 & 0xff);
        return b;
    }
    /**
     * byte[]转long类型(小端)
     * @param array
     * @return
     */
    public static long bytesToLongLittle( byte[] array )
    {
        return ((((long) array[ 0] & 0xff) << 0)
                | (((long) array[ 1] & 0xff) << 8)
                | (((long) array[ 2] & 0xff) << 16)
                | (((long) array[ 3] & 0xff) << 24)
                | (((long) array[ 4] & 0xff) << 32)
                | (((long) array[ 5] & 0xff) << 40)
                | (((long) array[ 6] & 0xff) << 48)
                | (((long) array[ 7] & 0xff) << 56));
    }

    /**
     * byte[]转long类型(大端)
     * @param array
     * @return
     */
    public static long bytesToLongBig( byte[] array )
    {
        return ((((long) array[ 0] & 0xff) << 56)
                | (((long) array[ 1] & 0xff) << 48)
                | (((long) array[ 2] & 0xff) << 40)
                | (((long) array[ 3] & 0xff) << 32)
                | (((long) array[ 4] & 0xff) << 24)
                | (((long) array[ 5] & 0xff) << 16)
                | (((long) array[ 6] & 0xff) << 8)
                | (((long) array[ 7] & 0xff) << 0));
    }

    public static String byteToString(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        return new String(data).trim();
    }


    public static String byteArrayToHex(byte[] data, boolean lowCase) {
        if (data == null) {
            return null;
        }
        if (lowCase) {
            return Hex.encodeHexString(data);
        }
        return Hex.encodeHexString(data).toUpperCase();
    }

    public static String byteArrayToHex(byte[] bs) {
        if (bs == null) {
            return null;
        }
        return Hex.encodeHexString(bs).toUpperCase();
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null) {
            return new byte[0];
        }
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        return Hex.decodeHex(hex);
    }

    public static byte[] hexToByteArray(String hex, int len) {

        byte[] bytes = Hex.decodeHex(hex);
        if (bytes.length == len) {
            return bytes;
        }
        if (bytes.length < len) {
            byte[] result = new byte[len];
            System.arraycopy(bytes, 0, result, len - bytes.length, bytes.length);
            return result;
        } else {
            return Arrays.copyOf(bytes, len);
        }

    }

    /**
     * 二维数组合并成一维数组
     *
     * @param bs
     * @return
     */
    public static byte[] reduceDimension(byte[][] bs) {
        int size = 0;
        for (byte[] b : bs) {
            size += b.length;
        }
        byte[] res = new byte[size];
        int pos = 0;
        for (byte[] b : bs) {
            System.arraycopy(b, 0, res, pos, b.length);
            pos += b.length;
        }
        return res;
    }

    public static byte[] strToByte(String str) {
        return str.getBytes();
    }

    public static byte[] strToByte(String str, String charsetName) {
        return str.getBytes(Charset.forName(charsetName));
    }

    public static byte[] strToByte(String str, int len) {
        byte[] bytes = str.getBytes();
        if (bytes.length > len) {
            return Arrays.copyOf(bytes, len);
        }
        byte[] result = new byte[len];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public static byte[] strToByte(String str, int len, String charsetName) {
        byte[] bytes = str.getBytes(Charset.forName(charsetName));
        if (bytes.length > len) {
            return Arrays.copyOf(bytes, len);
        }
        byte[] result = new byte[len];
        System.arraycopy(bytes, 0, result, len - bytes.length, bytes.length);
        return result;
    }


    public static int byteArrayToInt(byte[] data) {
        if (data == null || data.length < 1 || data.length > 4) {
            return -1;
        }
        int result = 0;
        int len = data.length;
        for (int i = 0; i < len; i++) {
            int ch = byteToInt(data[len - 1 - i]);

            result += ch << (8 * i);
        }
        if (data.length == 1 && result < 0) {
            result += 256;
        }
        return result;
    }


    public static int byteToInt(byte data) {
        return (data & 0xff);
    }


    public static byte[] longToByteArray(long x) {
        ByteBuffer longBuffer = ByteBuffer.allocate(Long.BYTES);
        longBuffer.putLong(0, x);
        return longBuffer.array();
    }

    public static long byteArrayToLong(byte[] data) {
        if (data == null || data.length == 0) {
            return 0;
        }
        long value = 0;
        for (int i = 0; i < data.length; i++) {
            value = (value << 8) + (data[i] & 0xff);
        }
        return value;
    }

    public static float byteArrayToFloat(byte[] data) {
        //ByteBuffer allocate = ByteBuffer.allocate(data.length);
        //allocate.put(data);
         ByteBuffer buffer = ByteBuffer.wrap(data);
        //return allocate.getFloat();
        return buffer.getFloat();
    }

    public static byte[] floatToByteArray(float f) {
        return ByteBuffer.allocate(Float.BYTES).putFloat(f).array();
    }

    public static byte[] intToByteArray(Object value, int arrayLen) {
        if (value == null) {
            return null;
        }
        return intToByteArray(Integer.parseInt(value.toString()), arrayLen);
    }

    public static byte[] shortToByteArray(short s) {
        return ByteBuffer.allocate(Short.BYTES).putShort(s).array();
    }

    public static short byteArrayToShort(byte[] data) {

        if (data.length == 1) {
            return data[0];
        }
        int value = 0;
        for (int i = 0; i < data.length; i++) {
            value = (value << 8) + (data[i] & 0xff);
        }
        return (short) value;
    }

    /**
     * 数字转换成byte[]数组
     *
     * @param value
     * @param arrayLen 数组长度
     * @return
     */
    public static byte[] intToByteArray(int value, int arrayLen) {
        byte[] bs = new byte[arrayLen];
        for (int i = 0; i < arrayLen; i++) {
            int cary = i * 8;
            bs[arrayLen - i - 1] = (byte) ((value >> cary) & 0xFF);
        }
        return bs;
    }

    public static byte[] intToByteArray(int value, Integer arrayLen) {
        return intToByteArray(value, arrayLen.intValue());
    }

    /**
     * 合并数组
     *
     * @param rest
     * @param
     * @return
     */
    public static byte[] concatAll(byte[]... rest) {
        if (rest.length == 0) {
            return new byte[0];
        } else if (rest.length == 1) {
            return rest[0];
        }
        int totalLength = 0;
        for (byte[] arr : rest) {
            totalLength += arr.length;
        }
        if (totalLength == 0) {
            return new byte[0];
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static String makeChecksum(String data) {
        if (data == null || data.equals("")) {
            return "";
        }
        int total = 0;
        int len = data.length();
        int num = 0;
        while (num < len) {
            String s = data.substring(num, num + 2);
            //System.out.println(s);
            total += Integer.parseInt(s, 16);
            num = num + 2;
        }
        /**
         * 用256求余最大是255，即16进制的FF
         */
        int mod = total % 256;
        String hex = Integer.toHexString(mod);
        len = hex.length();
        // 如果不够校验位的长度，补0,这里用的是两位校验
        if (len < 2) {
            hex = "0" + hex;
        }
        return hex;
    }
    public static byte[] listTobyte(List<Byte> list) {
        if (list == null || list.size() < 0) {
            return null;
        }

        byte[] bytes = new byte[list.size()];
        int i = 0;

        Iterator<Byte> iterator = list.iterator();
        while (iterator.hasNext()) {
            bytes[i] = iterator.next();
            i++;
        }
        return bytes;
    }

    public static byte[] listToBytes(List<byte[]> list) {
        if (list == null || list.size() < 0) {
            return null;
        }

        List<Byte> ls=new ArrayList<Byte>();
        Iterator<byte[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] bt= iterator.next();
            for(byte b:bt){
                ls.add(b);
            }
        }
        byte[] bytes = listTobyte(ls);
        return bytes;
    }

    /**
     * 将4字节转为带符号的整数（大端模式 最高位为 最高位为 1 为负 ，为0则为正数）
     *
     * @param data
     * @return
     */
    public static int fourBytesToSignedNumber(byte[] data, ByteOrder bo) {
        if (data == null || data.length < 1 || data.length > 4) {
            return -1;
        }

        if(bo.equals(ByteOrder.LITTLE_ENDIAN)){
            List<Byte> ls=new ArrayList<Byte>();
            for(int i=data.length;i>=0;i--){
                ls.add(data[i]);
            }
            data=listTobyte(ls);
        }

        ByteBuffer buffer;
        int i = 0;
        if(HexUtil.byteToInt(data[0])>0x7F){
            data[0] &= 0x7F;
            buffer = ByteBuffer.wrap(data);
            i = - buffer.getInt();
        }else{
            buffer = ByteBuffer.wrap(data);
            i = buffer.getInt();
        }

        //System.out.println("i:"+i);
        return i;
    }

    /**
     * 转换成8位长度的二进制字符串
     *
     * @param b
     * @return
     */
    public static String byteToBinaryString(byte b) {
        return String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
    }

    /**
     * 翻转字符器
     *
     * @param data
     * @return
     */
    public static String reverseString(String data) {
        return new StringBuilder(data).reverse().toString();
    }

    /**
     * 获得指定字节中从左边数起的第几位是0还是1，位置范围 0-7
     * @param data 待判断的字节
     * @param bitpos 位置范围 0-7
     * @return
     */
    public static char getByteBitFromLeft(byte data,int bitpos) {
        String bin = byteToBinaryString(data);
        return bin.charAt(bitpos);
    }

    /**
     * 获得指定字节中从右边数起的第几位是0还是1，位置范围 0-7
     * @param data 待判断的字节
     * @param bitpos 位置范围 0-7
     * @return
     */
    public static char getByteBitFromRigth(byte data,int bitpos) {
        String bin = reverseString(byteToBinaryString(data));
        return bin.charAt(bitpos);
    }

    public static void main(String[] args) {
        String s="2b733263001b01004a489640446714983434363731343938040b";
        s+=HexUtil.makeChecksum(s);
        System.out.println("s:"+s.toString());


        byte[] array = new byte[4];
        //int占用4个byte，值域是-2147483648~2147483647
        //array[0] = (byte)0x7F;
        array[0] = (byte)0xFF;
        array[1] = (byte)0xff;
        array[2] = (byte)0xff;
        array[3] = (byte)0xff;
        //array[3] = (byte)0x7F;


        array[0] = (byte)0x80;
        array[1] = (byte)0x00;
        array[2] = (byte)0x00;
        array[3] = (byte)0x02;

        int k = fourBytesToSignedNumber(array,ByteOrder.BIG_ENDIAN);
        System.out.println("k:"+k);

        array[0] = (byte)0x80;
        array[1] = (byte)0x00;
        array[2] = (byte)0x00;
        array[3] = (byte)0x02;
        System.out.println("byteToBinaryString:"+byteToBinaryString(array[0]));

        System.out.println("getByteBit:"+getByteBitFromLeft(array[0],0));
        System.out.println("getByteBit:"+getByteBitFromRigth(array[0],7));



    }
}
