package com.vcarecity.allcommon.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
	public static final long MS_ONE_DAY = 86400000L;
	
	public static final long MS_DAY_FROM = 28800000L;
	
	public static long clearTime(long time){
		return (time + MS_DAY_FROM) / MS_ONE_DAY * MS_ONE_DAY - MS_DAY_FROM;
	}
	
	public static Date clearTime(Date d){
		return new Date((d.getTime() + MS_DAY_FROM) / MS_ONE_DAY * MS_ONE_DAY - MS_DAY_FROM);
	}
	
	public static Date getDate(Date date, Time time){
		return new Date(clearTime(date.getTime()) + time.getTime() + MS_DAY_FROM);
	}
	
	public static long getDate(long date, long time){
		return clearTime(date) + time + MS_DAY_FROM;
	}
	public static Timestamp getTimestamp(){
		Timestamp d = new Timestamp(System.currentTimeMillis()); 
		return d;
	}
	
	public static Timestamp getTimestamp(Date date, Time time){
		return new Timestamp(clearTime(date.getTime()) + time.getTime() + MS_DAY_FROM);
	}
	
	public static Timestamp getTimestamp(Timestamp stamp, Time time){
		return new Timestamp(clearTime(stamp.getTime()) + time.getTime() + MS_DAY_FROM);
	}
	
	public static Timestamp getTimestamp(String dateStr){
		return getTimestamp(dateStr,"yyyy-MM-dd HH:mm:ss");
	}
	
	public static Timestamp getTimestamp(String dateStr, String fmt){
		SimpleDateFormat sf = new SimpleDateFormat(fmt);
		Timestamp tm=null;
		try {
			dateStr=dateStr.replace("0A", "10");
			java.util.Date date=null;
			if(dateStr.isEmpty()){
				date = sf.parse(getLocalTime());
			}else{
				date = sf.parse(dateStr);
			}
			Calendar cal = Calendar.getInstance();
			cal.setTime(date);
			tm=new Timestamp(cal.getTimeInMillis());
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return tm;
	}
	
	public static String getTimestampString(String dateStr, String fmt){
		SimpleDateFormat sf = new SimpleDateFormat(fmt);
		SimpleDateFormat sdfTime=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String tm=null;
		try {
			dateStr=dateStr.replace("0A", "10");
			java.util.Date date=null;
			if(dateStr.isEmpty()){
				date = sf.parse(getLocalTime());
			}else{
				date = sf.parse(dateStr);
			}			
			tm=sdfTime.format(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return tm;
	}
	
	public static String getDateString(String dateStr, String fmt){
		SimpleDateFormat sf = new SimpleDateFormat(fmt);
		SimpleDateFormat sdfTime=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date=null;
		try {
			date = sdfTime.format(sf.parse(dateStr));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}
	
	public static java.util.Date getUtilDate(String dateStr, String fmt){
		SimpleDateFormat sf = new SimpleDateFormat(fmt);
		java.util.Date date=null;
		try {
			date = sf.parse(dateStr);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}
	
	private static String conversion(int field) {
		String str;
		if (field < 10) {
			str = "0" + field;
		} else {
			str = field + "";
		}
		return str;
	}	
	private static String AM_MPTime(int field, int isRest) {
		String str;
		if (isRest == 1) {
			str = field + 12 + "";
		} else {
			str = field + "";
		}
		return str;
	}
	
	public static String getSystemTime() {
		Calendar date = new GregorianCalendar();
		StringBuffer str = new StringBuffer();
		int year = date.get(Calendar.YEAR);
		String month = conversion(date.get(Calendar.MONTH) + 1);
		String day = conversion(date.get(Calendar.DATE));
		String hour = AM_MPTime(date.get(Calendar.HOUR),date.get(Calendar.AM_PM));
		String minute = conversion(date.get(Calendar.MINUTE));
		String second = conversion(date.get(Calendar.SECOND));
		str.append(year);
		str.append(month);
		str.append(day);
		str.append(hour);
		str.append(minute);
		str.append(second);
		return str.toString();
	}
	
	public static String getLocalDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(new java.util.Date());
	}
	
	public static String getLocalTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new java.util.Date());
	}
	
	public static String getNoYearTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
		return sdf.format(new java.util.Date());
	}
	
	public static String getFullDateTimeString(String dateTimeString,String dataTimeFormats){ 		
		String[] tmpAtr=new String[]{"19990101","010101"};;
		String dateSimeStr="";
		String regexp="[`~!@#$%^&*()+|{}':;',\\-\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？年月日时分秒 ]";
		Calendar a=Calendar.getInstance();
		
		if("\\d{4}年\\d{2}月\\d{2}日\\d{2}时\\d{2}分".equals(dataTimeFormats)){
			dateSimeStr=dateTimeString+"00秒";
		}else if("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+dateTimeString+":00";
		}else if("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+dateTimeString;
			//\d{1,4}-\d{1,2}-\d{1,2}\d{1,2}:\d{1,2}:\d{1,2}
		}else if("\\d{4}-\\d{1,2}-\\d{1,2}\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			dateSimeStr=dateTimeString;
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}年\\s*\\d{1,2}月\\s*\\d{1,2}日\\s*\\d{1,2}:\\s*\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString.replaceAll("\\s+", ""),regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);			
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+"00";
		}else if("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			String ss=tmpA[4];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+ss;
		}else if("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);			
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+"00";
		}else if("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			String ss=tmpA[4];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+ss;
		}else if("\\d{4}\\/\\d{1,2}\\/\\d{1,2}\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){			
			dateSimeStr=dateTimeString;
		}else if("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();	
			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();	
			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();	
			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);			
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+"00";
		}else if("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			String ss=tmpA[4];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+ss;
		}else if("\\d{2,4}\\.\\d{1,2}.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;		
		}else if("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+dateTimeString;		
		}else if("\\d{2}年\\d{2}月\\d{2}日\\d{2}时\\d{2}分".equals(dataTimeFormats)){//\\d{4}年\\d{2}月\\d{2}日 \\d{2}时\\d{2}分
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}年\\d{2}月\\d{2}日 \\d{2}时\\d{2}分".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[4].trim();
			String s=tmpA[5].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=a.get(Calendar.YEAR)+"/"+dateTimeString+":00";
		}else if("\\d{2}\\/\\d{2}\\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=a.get(Calendar.YEAR)+"/"+dateTimeString+":00";
		}else if("\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+dateTimeString+":00";
		}else if("\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateSimeStr=a.get(Calendar.YEAR)+"-"+dateTimeString+":00";
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""),regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日\\d{1,2}时\\d{1,2}分\\d{1,2}秒".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""),regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日 \\d{1,2}时\\d{1,2}分\\d{1,2}秒".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""),regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""),regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}月\\d{1,2}日\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);			
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+"00";
		}else if("\\d{1,2}月\\d{1,2}日 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);			
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+"00";
		}else if("\\d{1,2}月\\d{1,2}日\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			String ss=tmpA[4];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+ss;
		}else if("\\d{1,2}月\\d{1,2}日 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String m=tmpA[0];
			String d=tmpA[1];
			String h=tmpA[2];
			String s=tmpA[3];
			String ss=tmpA[4];
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=a.get(Calendar.YEAR)+m+d+h+s+ss;
		}else if("\\d{2,4}年\\d{1,2}月\\d{1,2}日\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2,4}年\\d{1,2}月 \\d{1,2}日\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}年\\d{2}月\\d{2}日\\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}年\\d{2}月\\d{2}日 \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}年\\d{2}月\\d{2}日\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}年\\d{2}月\\d{2}日 \\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";
			y=StringUtils.leftAppendZero(y, 4);
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}年\\d{2}月\\d{2}日\\d{2}时\\d{2}分".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+tmpA[0].trim();
			String m=tmpA[0].trim();
			String d=tmpA[1].trim();
			String h=tmpA[2].trim();
			String s=tmpA[3].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}年\\d{2}月\\d{2}日 \\d{2}时\\d{2}分".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+tmpA[0].trim();
			String m=tmpA[0].trim();
			String d=tmpA[1].trim();
			String h=tmpA[2].trim();
			String s=tmpA[3].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}月\\d{1,2}日\\d{1,2}时\\d{1,2}分".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(a.get(Calendar.YEAR));
			String m=tmpA[0].trim();
			String d=tmpA[1].trim();
			String h=tmpA[2].trim();
			String s=tmpA[3].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;			
		}else if("\\d{4}年\\d{1,2}月\\d{1,2}日\\d{1,2}时\\d{1,2}分".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+tmpA[0].trim();
			String m=tmpA[0].trim();
			String d=tmpA[1].trim();
			String h=tmpA[2].trim();
			String s=tmpA[3].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{4}/\\d{1,2}/\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[3].trim();
			String m=tmpA[4].trim();
			String d=tmpA[5].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{1,2}/\\d{1,2}/\\d{4}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[5].trim();
			String m=tmpA[3].trim();
			String d=tmpA[4].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if("\\d{4}\\/\\d{1,2}\\/\\d{1,2}/ \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[4].trim();
			String s=tmpA[5].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";			
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{2}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[3].trim();
			String m=tmpA[4].trim();
			String d=tmpA[5].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{4}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[3].trim();
			String m=tmpA[4].trim();
			String d=tmpA[5].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss=tmpA[5].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{4}\\.\\d{2}\\.\\d{2}\\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].substring(0, 2);
			String h=tmpA[2].substring(2);
			String s=tmpA[3].trim();
			String ss=tmpA[4].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[5].trim();
			String m=tmpA[4].trim();
			String d=tmpA[3].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}".equals(dataTimeFormats)){
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[5].trim();
			String m=tmpA[4].trim();
			String d=tmpA[3].trim();
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss=tmpA[2].trim();		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{1,2}时\\d{1,2}分".equals(dataTimeFormats)){
			dateTimeString = getLocalDate()+" "+dateTimeString;
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=String.valueOf(Calendar.YEAR);
			String m=String.valueOf(Calendar.MONTH);
			String d=String.valueOf(Calendar.DATE);
			String h=tmpA[0].trim();
			String s=tmpA[1].trim();
			String ss="00";		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{2}:\\d{2}".equals(dataTimeFormats)){
			dateTimeString = getLocalDate()+" "+dateTimeString;
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}else if ("\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)){
			dateTimeString = getLocalDate()+" "+dateTimeString;
			String[] tmpA=StringUtils.stringSplit(dateTimeString,regexp);
			String y=tmpA[0].trim();
			String m=tmpA[1].trim();
			String d=tmpA[2].trim();
			String h=tmpA[3].trim();
			String s=tmpA[4].trim();
			String ss="00";		
			if(y.length()<4){
				y=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+y;
			}
			m=StringUtils.leftAppendZero(m, 2);
			d=StringUtils.leftAppendZero(d, 2);
			h=StringUtils.leftAppendZero(h, 2);
			s=StringUtils.leftAppendZero(s, 2);
			ss=StringUtils.leftAppendZero(ss, 2);				
			dateSimeStr=y+m+d+h+s+ss;
		}
		
		//\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}
		
		dateSimeStr=StringUtils.StringFilterSpecificCharacter(regexp,dateSimeStr);//  dateSimeStr.replaceAll(regexp,"");
		return TimeUtil.getTimestampString(dateSimeStr,"yyyyMMddHHmmss");
	}
	
	/**
	 * 
	 * <b>功能说明 : </b>将不完整的字符串转换为完整的字符串. <br/>
	 * <b>适用条件 : </b>TODO(这里描述这个方法适用条件 – 可选,如果不需说明则删除此句).<br/>
	 * <b>执行流程 : </b>TODO(这里描述这个方法的执行流程 – 可选,如果不需说明则删除此句).<br/>
	 * <b>使用示例 : </b>TODO(这里描述这个方法的使用方法 – 可选,如果不需说明则删除此句).<br/>
	 * <b>注意事项 : </b>TODO(这里描述这个方法的注意事项 – 可选,如果不需说明则删除此句).<br/>
	 * @param dateTimeString
	 * @param dataFormats
	 * @param timeFormats
	 * @return String 说明:TODO(这里描述返回对象是什么 – 可选,如果不需说明则删除此句).
	 * @throws
	 * <br/><br/><br/><b>作者 </b>wsq<br/>
	 * <b>创建时间 : </b>2016年4月2日 上午11:57:59<br/>
	 */
	public static Timestamp getFullDateTimeString(String dateTimeString,String dataFormats,String timeFormats){ 		
		String[] tmpAtr=new String[]{"19990101","010101"};;
		String dateStr="";
		String timeStr="";
		if(dateTimeString.indexOf(" ")>0){
			tmpAtr=dateTimeString.split(" ");
			dateStr=tmpAtr[0];
			timeStr=tmpAtr[1];
		}else if(dateTimeString.indexOf("日")>0){
			tmpAtr=dateTimeString.split("日");
			dateStr=tmpAtr[0]+"日";
			timeStr=tmpAtr[1];
		}else{
			return TimeUtil.getTimestamp("19990101010101","yyyyMMddHHmmss");
		}
		Calendar a=Calendar.getInstance();
		
		String[] dayFormats=dataFormats.split("\\|",100);
		
		for(String date_format:dayFormats){
			date_format =StringUtils.StringFilterNoColon(date_format).toString();
			if ("MMDD".equalsIgnoreCase(date_format)) {
				dateStr=a.get(Calendar.YEAR)+StringUtils.StringFilter(dateStr);
			}else if ("M月D日".equalsIgnoreCase(date_format)) {			
				String[] tmpA=StringUtils.stringSplit(dateStr,"-|月|/"); //  dateStr.split("月");
				String m=tmpA[0];
				m=StringUtils.leftAppendZero(m, 2);
				String d=StringUtils.removeChinese(tmpA[1]);
				d=StringUtils.leftAppendZero(d, 2);
				dateStr=a.get(Calendar.YEAR)+StringUtils.StringFilter(m+d);
			}else if ("MM月DD日".equalsIgnoreCase(date_format)) {			
				String[] tmpA=StringUtils.stringSplit(dateStr,"-|月|/"); //  dateStr.split("月");
				String m=tmpA[0];
				m=StringUtils.leftAppendZero(m, 2);
				String d=StringUtils.removeChinese(tmpA[1]);
				d=StringUtils.leftAppendZero(d, 2);
				dateStr=a.get(Calendar.YEAR)+StringUtils.StringFilter(m+d);
			}else if ("YYMMDD".equalsIgnoreCase(date_format)) {
				dateStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+StringUtils.StringFilter(dateStr);
			}else if ("YY年M月D日".equalsIgnoreCase(date_format)) {
				String[] tmpA=StringUtils.stringSplit(dateStr,"-|年|月|日|/");
				String y=tmpA[0];
				String m=tmpA[1];
				String d=tmpA[2];
				m=StringUtils.leftAppendZero(m, 2);
				d=StringUtils.leftAppendZero(d, 2);
				dateStr=a.get(Calendar.YEAR)+StringUtils.StringFilter(y+m+d);				
			}else if ("YY年MM月DD日".equalsIgnoreCase(date_format)) {
				dateStr=String.valueOf(a.get(Calendar.YEAR)).substring(0,2)+StringUtils.StringFilterSpecificCharacter("年|月|日",dateStr);
			}else if ("YYYY年M月D日".equalsIgnoreCase(date_format)) {
				String[] tmpA=StringUtils.stringSplit(dateStr,"-|年|月|日|/");
				String y=tmpA[0];
				String m=tmpA[1];
				String d=tmpA[2];
				m=StringUtils.leftAppendZero(m, 2);
				d=StringUtils.leftAppendZero(d, 2);
				dateStr=a.get(Calendar.YEAR)+StringUtils.StringFilter(y+m+d);	
			}else if ("YYYY年MM月DD日".equalsIgnoreCase(date_format)) {
				dateStr=StringUtils.StringFilterSpecificCharacter("年|月|日",dateStr);
			}else if ("DDMM".equalsIgnoreCase(date_format)) {
				if (dateStr.replaceAll(" ", "").length()==4){
					dateStr=dateStr.substring(2, 4)+dateStr.substring(0, 2);
				}else{
					String[] tmp= StringUtils.stringSplit(dateStr);
					dateStr=a.get(Calendar.YEAR)+tmp[1]+tmp[0];																
				}
			}else if ("YYYYMMDD".equalsIgnoreCase(date_format)) {
				dateStr=StringUtils.StringFilter(dateStr);
			}else if ("MMDDYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
				if (dateStr.replaceAll(" ", "").length()==4){
					dateStr=dateStr.substring(4, 8)+dateStr.substring(0, 2)+dateStr.substring(2, 4);
				}else{
					String[] tmp= StringUtils.stringSplit(dateStr);
					dateStr=tmp[2]+tmp[0]+tmp[1];																
				}
			}else if ("DDMMYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
				if (dateStr.replaceAll(" ", "").length()==4){
					dateStr=dateStr.substring(4, 8)+dateStr.substring(2, 4)+dateStr.substring(0, 2);
				}else{
					String[] tmp= StringUtils.stringSplit(dateStr);
					dateStr=tmp[2]+tmp[1]+tmp[0];																
				}
			}else if ("YYYYDDMM".equalsIgnoreCase(date_format.replace("/", ""))) {
				if (dateStr.replaceAll(" ", "").length()==4){
					dateStr=dateStr.substring(0, 4)+dateStr.substring(6, 8)+dateStr.substring(4, 6);
				}else{
					String[] tmp= StringUtils.stringSplit(dateStr);
					dateStr=tmp[2]+tmp[1]+tmp[0];																
				}
			}else{
				dateStr = "19990101";
			}
			
			if(!dateStr.equals("19990101")){
				break;
			}
			
		}
		
		
		String[] timeFormat=timeFormats.split("\\|",100);		
		for(String time_format:timeFormat){
			time_format =StringUtils.StringFilter(time_format).toString();
			if(timeStr.indexOf("时")>0){
				String regEx="时|分|秒"; 
				Pattern p = Pattern.compile(regEx); 
				Matcher m = p.matcher(timeStr);
				timeStr = m.replaceAll("").trim();
			}
			
			if(timeStr.indexOf(":")>0){
				tmpAtr=timeStr.split(":");
				if(tmpAtr.length>=3){
					timeStr=StringUtils.leftAppendZero(tmpAtr[0], 2)+StringUtils.leftAppendZero(tmpAtr[1], 2)+StringUtils.leftAppendZero(tmpAtr[2], 2);	
				}else if(tmpAtr.length==2){
					timeStr=StringUtils.leftAppendZero(tmpAtr[0], 2)+StringUtils.leftAppendZero(tmpAtr[1], 2)+"00";	
				}else if(tmpAtr.length==1){
					timeStr=StringUtils.leftAppendZero(tmpAtr[0], 2)+StringUtils.leftAppendZero(tmpAtr[1], 2)+StringUtils.leftAppendZero(tmpAtr[2], 2);
				}else {
					timeStr= "00:00:00";
				}
			}
			
			if ("HHmm".equalsIgnoreCase(time_format)) {
				timeStr=StringUtils.StringFilter(timeStr)+"00";
			}else if ("HHmmss".equalsIgnoreCase(time_format)) {
				timeStr=StringUtils.StringFilter(timeStr);
			}else if ("HHmi".equalsIgnoreCase(time_format)) {
				timeStr=StringUtils.StringFilter(timeStr)+"00";
			}else if ("HHmiss".equalsIgnoreCase(time_format)) {
				timeStr=StringUtils.StringFilter(timeStr);
			}else{
				timeStr = "010101";
			}
			
			if(!timeStr.equals("010101")){
				break;
			}
		}
		
		return TimeUtil.getTimestamp(dateStr+timeStr,"yyyyMMddHHmmss");
	}	
		
	
	
	public static void main(String[] args) {
		String year=TimeUtil.getLocalTime().substring(0,2);
		String dateTime=TimeUtil.getDateString("211221215436","yyMMddHHmmss");
		System.out.println("dateTime:"+dateTime);
		System.out.println(TimeUtil.getTimestamp("2015-12-21 21:54:36"));
		System.out.println(TimeUtil.getTimestamp("20151221215436","yyyyMMddHHmmss"));

		System.out.println(TimeUtil.getDateString("20151221215436","yyyyMMddHHmmss"));
		
		System.out.println(TimeUtil.getNoYearTime());
		
		System.out.println(TimeUtil.getFullDateTimeString("7月26日16:08","M月D日|MM-DD","HHMM"));

		Calendar date = new GregorianCalendar();
		System.out.println( date.get(Calendar.YEAR));
		
		
		String[] tmpA=StringUtils.stringSplit("2016年12月28日","-|年|月|日|/");
		for(String s:tmpA){
			System.out.println("s="+s);
		}
		
		double i= Double.parseDouble("0.0");
		System.out.println("i="+i);
	}
}