/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.onenet.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.onenet.bean.OnenetMessageBodyBean;
import com.vcarecity.onenet.service.OnenetDecryptService;
import com.vcarecity.onenet.util.OnenetUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnenetDecryptServiceImpl
implements OnenetDecryptService {
    private static Logger logger = LoggerFactory.getLogger(OnenetDecryptServiceImpl.class);
    private final ObjectMapper objectMapper;

    public OnenetDecryptServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String decrypt(String body, String token, boolean encrypted, String aesKey) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        OnenetMessageBodyBean msgBody = this.decryptBody(body, encrypted);
        if (msgBody == null) {
            logger.warn("data body empty error");
            return null;
        }
        boolean dataRight = OnenetUtil.checkSignature(msgBody, token);
        if (!dataRight) {
            logger.warn("data receive signature error");
            return null;
        }
        try {
            if (!encrypted) {
                return this.objectMapper.writeValueAsString((Object)msgBody);
            }
            return OnenetUtil.decryptMsg(msgBody, aesKey);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private OnenetMessageBodyBean decryptBody(String body, boolean encrypted) {
        JsonNode jsonMsgNode;
        try {
            jsonMsgNode = this.objectMapper.readTree(body);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
        OnenetMessageBodyBean msg = new OnenetMessageBodyBean();
        msg.setNonce(jsonMsgNode.get("nonce").asText());
        msg.setMsgSignature(jsonMsgNode.get("msg_signature").asText());
        String enKey = encrypted ? "enc_msg" : "msg";
        JsonNode msgNode = jsonMsgNode.get(enKey);
        if (msgNode == null) {
            return null;
        }
        msg.setMsg(msgNode.asText());
        return msg;
    }
}

