/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.onenet.util;

import com.vcarecity.onenet.bean.OnenetMessageBodyBean;
import com.vcarecity.onenet.util.MessageDigestUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class OnenetUtil {
    public static boolean checkToken(String msg, String nonce, String signature, String token) {
        byte[] paramB = new byte[token.length() + 8 + msg.length()];
        System.arraycopy(token.getBytes(), 0, paramB, 0, token.length());
        System.arraycopy(nonce.getBytes(), 0, paramB, token.length(), 8);
        System.arraycopy(msg.getBytes(), 0, paramB, token.length() + 8, msg.length());
        String sig = com.sun.org.apache.xerces.internal.impl.dv.util.Base64.encode(MessageDigestUtil.getMd5().digest(paramB));
        return sig.equals(signature.replace(' ', '+'));
    }

    public static boolean checkSignature(OnenetMessageBodyBean obj, String token) {
        byte[] signature = new byte[token.length() + 8 + obj.getMsg().toString().length()];
        System.arraycopy(token.getBytes(), 0, signature, 0, token.length());
        System.arraycopy(obj.getNonce().getBytes(), 0, signature, token.length(), 8);
        System.arraycopy(obj.getMsg().toString().getBytes(), 0, signature, token.length() + 8, obj.getMsg().toString().length());
        MessageDigestUtil.getMd5().update(signature);
        String calSig = Base64.encodeBase64String((byte[])MessageDigestUtil.getMd5().digest());
        return calSig.equals(obj.getMsgSignature());
    }

    public static String decryptMsg(OnenetMessageBodyBean obj, String encodeKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] encMsg = Base64.decodeBase64((String)obj.getMsg().toString());
        byte[] aesKey = Base64.decodeBase64((String)(encodeKey + "="));
        SecretKeySpec secretKey = new SecretKeySpec(aesKey, 0, 32, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(2, (Key)secretKey, new IvParameterSpec(aesKey, 0, 16));
        byte[] allMsg = cipher.doFinal(encMsg);
        byte[] msgLenBytes = new byte[4];
        System.arraycopy(allMsg, 16, msgLenBytes, 0, 4);
        int msgLen = OnenetUtil.getMsgLen(msgLenBytes);
        byte[] msg = new byte[msgLen];
        System.arraycopy(allMsg, 20, msg, 0, msgLen);
        return new String(msg);
    }

    private static int getMsgLen(byte[] arrays) {
        int len = 0;
        len += (arrays[0] & 0xFF) << 24;
        len += (arrays[1] & 0xFF) << 16;
        len += (arrays[2] & 0xFF) << 8;
        return len += arrays[3] & 0xFF;
    }
}

