package com.vcarecity.dtu.issued.read;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/05/10
 * <p>
 * 设置电气火灾探测器温度告警值
 * 第1个字节为线路号，后一个字节为告警阈值，范围0-150℃（0x00-0x96），真实值高于此值会告警
 */

public class IssuedRead785 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        if (data == null) {
            throw new NoRequireKeyException("data");
        }
        Object lineNo = data.get("lineNo");
        if (lineNo == null) {
            throw new NoRequireKeyException("lineNo");
        }
        return HexUtil.intToByteArray(Integer.parseInt(lineNo.toString()), 1);
    }

}
