package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * 英文字库 T+E+P
 * 0180
 */

public class IssuedWrite384 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object fontLibType = data.get("fontLibType");
        if (fontLibType == null) {
            throw new NoRequireKeyException("fontLibType");
        }

        Object chars = data.get("char");
        if (chars == null) {
            throw new NoRequireKeyException("char");
        }

        Object dotArray = data.get("dotArray");
        if (dotArray == null) {
            throw new NoRequireKeyException("dotArray");
        }

        return HexUtil.concatAll(
                HexUtil.intToByteArray(fontLibType.toString(), 1),
                HexUtil.intToByteArray(chars.toString(), 1),
                HexUtil.hexToByteArray(dotArray.toString(), 16));
    }

}
