package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/13
 * 复位
 * 0200
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test512()
 */

public class IssuedWrite512 extends AbstractConverter {

    private static final String RESET = "reset";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object o = data.get(RESET);
        if (o == null) {
            throw new NoRequireKeyException(RESET);
        }
        return HexUtil.intToByteArray(Integer.parseInt(o.toString()), 1);
    }

}
