package com.vcarecity.dtu.issued.write;





import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * @author Kerry on 18/04/13
 * <p>
 * 终端对时
 * 0202
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test514()
 */

public class IssuedWrite514 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyMMddHHmmss"));

        if (data != null) {
            Object time = data.get(DtuProtocolJsonConstant.DATE_TIME);
            if (time != null && time.toString().trim().length() != 0) {
                dateTime = time.toString();
            }
        }
        return HexUtil.hexToByteArray(dateTime, 6);
    }

}
