package com.vcarecity.dtu.issued.write;




import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/13
 * <p>
 * 心跳间隔
 * 0204
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test516()
 */

public class IssuedWrite516 extends AbstractConverter {

    private static final String HEART_BEAT = "heartBeat";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object hb = data.get(HEART_BEAT);
        if (hb == null) {
            throw new NoRequireKeyException(HEART_BEAT);
        }
        return HexUtil.intToByteArray(Integer.parseInt(hb.toString()), 1);
    }

}
