package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 下发FTP升级参数
 * 0206
 * <p>
 */

public class IssuedWrite518 extends AbstractConverter {

    public static final String PORT = "port";
    public static final String IP = "ip";
    public static final String FTP_USER = "ftpUser";
    public static final String FTP_PASS = "ftpPass";
    public static final String FILE_NAME = "fileName";


    @NotNull
    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {

        byte[] port = getInt(data, PORT, 2);
        byte[] ip = getString(data, IP, 30);
        byte[] ftpUser = getString(data, FTP_USER, 15);
        byte[] ftpPass = getString(data, FTP_PASS, 15);
        byte[] fileName = getString(data, FILE_NAME, 30);

        return HexUtil.concatAll(
                port,
                ip,
                ftpUser,
                ftpPass,
                fileName);
    }

    private byte[] getInt(Map<String, Object> data, String key, int len) throws NoRequireKeyException {
        Object o = data.get(key);
        if (o == null) {
            throw new NoRequireKeyException(key);
        }
        return HexUtil.intToByteArray(o, len);
    }

    private byte[] getString(Map<String, Object> data, String key, int len) throws NoRequireKeyException {
        Object o = data.get(key);
        if (o == null) {
            throw new NoRequireKeyException(key);
        }
        byte[] bd = o.toString().getBytes();
        byte[] res = new byte[len];

        System.arraycopy(bd, 0, res, 0, bd.length);

        return res;
    }

}
