package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 串口号+波特率+校验方式+停止位
 * 检验方式
 * 0207
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test519()
 */

public class IssuedWrite519 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object serialPort = data.get("serialPort");
        if (serialPort == null) {
            throw new NoRequireKeyException("serialPort");
        }

        Object baudRate = data.get("baudRate");
        if (baudRate == null) {
            throw new NoRequireKeyException("baudRate");
        }

        Object checkMode = data.get("checkMode");
        if (checkMode == null) {
            throw new NoRequireKeyException("checkMode");
        }

        Object stopBit = data.get("stopBit");
        if (stopBit == null) {
            throw new NoRequireKeyException("stopBit");
        }

        Object dataLen = data.get("dataLen");
        if (dataLen == null) {
            dataLen = "0";
        }

        return HexUtil.concatAll(
                HexUtil.intToByteArray(serialPort.toString(), 1),
                HexUtil.intToByteArray(baudRate.toString(), 4),
                HexUtil.intToByteArray(checkMode.toString(), 1),
                HexUtil.intToByteArray(stopBit.toString(), 1),
                HexUtil.intToByteArray(dataLen.toString(), 1));
    }

}
