package com.vcarecity.dtu.issued.write;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author Kerry on 18/10/23
 * <p>
 * 0x020D	电池低电量报警阈值设置	4	W/R	Byte[2] 电量0%时的电压
 * Byte[2] 低电量报警时的电压
 * 电池电压单位：mV
 * 针对无线烟感的电池电压设置范围：1800mV-2700mV
 */

public class IssuedWrite525 extends AbstractConverter {

    private static final String ZERO_PCT_V = "zeroPctV";
    private static final String LOW_PCT_V = "lowPctV";


    @NotNull
    @Override
    public byte[] convertItemBody(@NotNull Integer id, Map<String, Object> data) throws NoRequireKeyException {

        Object zeroPctV = data.get(ZERO_PCT_V);
        if (zeroPctV == null) {
            throw new NoRequireKeyException(ZERO_PCT_V);
        }
        Object lowPctV = data.get(LOW_PCT_V);
        if (lowPctV == null) {
            throw new NoRequireKeyException(LOW_PCT_V);
        }

        return HexUtil.concatAll(
                HexUtil.intToByteArray(zeroPctV, 2),
                HexUtil.intToByteArray(lowPctV, 2)
        );
    }
}
