package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 针对读取设备二维码设备类型、地址、IMEI
 * 02F8
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test760()
 */

public class IssuedWrite760 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object equipmentType = data.get("equipmentType");
        if (equipmentType == null) {
            throw new NoRequireKeyException("equipmentType");
        }
        Object equipmentAddress = data.get("equipmentAddress");
        if (equipmentAddress == null) {
            throw new NoRequireKeyException("equipmentAddress");
        }
        Object imeiNo = data.get("imeiNo");
        if (imeiNo == null) {
            throw new NoRequireKeyException("imeiNo");
        }
        Object ccid = data.get("ccid");
        if (ccid == null) {
            throw new NoRequireKeyException("ccid");
        }

        return HexUtil.concatAll(
                HexUtil.strToByte(equipmentType.toString(), 10),
                HexUtil.strToByte(":", 1),
                HexUtil.hexToByteArray(equipmentAddress.toString(), 6),
                HexUtil.strToByte(":", 1),
                HexUtil.hexToByteArray(imeiNo.toString(), 16),
                HexUtil.strToByte(":", 1),
                HexUtil.strToByte(ccid.toString(), 21)
        );
    }

}
