package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 测量点状态
 * 0301
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test769()
 */

public class IssuedWrite769 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object state = data.get("state");
        if (state == null) {
            throw new NoRequireKeyException("state");
        }
        return HexUtil.intToByteArray(state.toString(), 1);
    }

}
