package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 测量点采集周期 单位:分钟 0表示主动上传
 * 0304
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test772()
 */

public class IssuedWrite772 extends AbstractConverter {
    private static final String PERIOD = "period";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object p = data.get(PERIOD);
        if (p == null) {
            throw new NoRequireKeyException(PERIOD);
        }
        return HexUtil.intToByteArray(p.toString(), 2);
    }

}
