package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 气体传感器电源自动关闭功能,适用于ZC9000S
 * 0306
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test774()
 */

public class IssuedWrite774 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object autoClosePower = data.get("autoClosePower");
        if (autoClosePower == null) {
            throw new NoRequireKeyException("autoClosePower");
        }
        return HexUtil.intToByteArray(autoClosePower.toString(), 1);
    }

}
