package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 液位告警上限和下限，适用于ZC9000L
 * 0309
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test777()
 */

public class IssuedWrite777 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object alarmUpperLimit = data.get("alarmUpperLimit");
        if (alarmUpperLimit == null) {
            throw new NoRequireKeyException("alarmUpperLimit");
        }
        Object alarmLowerLimit = data.get("alarmLowerLimit");
        if (alarmLowerLimit == null) {
            throw new NoRequireKeyException("alarmLowerLimit");
        }

        return HexUtil.concatAll(
                HexUtil.intToByteArray(alarmUpperLimit.toString(), 2),
                HexUtil.intToByteArray(alarmLowerLimit.toString(), 2));
    }

}
