package com.vcarecity.dtu.response;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public class HeartBeatResponse extends AbstractConverter {


    /**
     * 心跳没有.消息流水,测量点
     *
     * @param sn
     * @param equipmentNo
     * @return
     */
    @Override
    protected byte[] customSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        return new byte[0];
    }

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        //heart beat not input here
        return new byte[0];
    }

    /**
     * 强制覆盖方法,返回 new byte[0]
     *
     * @param sn
     * @param equipmentNo
     * @param list
     * @return
     * @throws NoRequireKeyException
     */
    @Override
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {
        return new byte[0];
    }

}
