package com.vcarecity.dtu.response;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public class ReportResponse extends AbstractConverter {

    @Override
    public byte[] convertItemBody(@NotNull Integer id, Map<String, Object> data) throws NoRequireKeyException {
        if (data == null) {
            throw new NoRequireKeyException("data");
        }
        byte[] bytes = HexUtil.intToByteArray(id, DtuProtocolConfig.DTU_INFO_ID_LEN);
        //上报数据直接返回 00
        return HexUtil.concatAll(bytes, HexUtil.intToByteArray(0, 1));
    }

    /**
     * 强制覆盖...返回第第一个
     *
     * @param sn
     * @param equipmentNo
     * @param list
     * @return
     * @throws NoRequireKeyException
     */
    @Override
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        BaseJsonViewBean.DataItemDTO dataItemDTO = list.get(0);
        return convertItemBody(dataItemDTO.getId(), dataItemDTO.getData());
    }
}
