package com.vcarecity.dtu.service.impl;


import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.common.service.IParserFrameService;
import com.vcarecity.common.util.CopyUtil;
import com.vcarecity.dtu.parser.BaseFrameParser;
import com.vcarecity.dtu.upload.heartbeat.HeartBeatParser;
import com.vcarecity.dtu.upload.login.BatteryLoginParser;
import com.vcarecity.dtu.upload.login.LoginParser;
import com.vcarecity.dtu.upload.read.ReadData;
import com.vcarecity.dtu.upload.report.ReportData;
import com.vcarecity.dtu.upload.request.PollRequest87;
import com.vcarecity.dtu.upload.write.WriteData;
import com.vcarecity.dtu.upload.write.WriteDataCommon;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Kerry on 18/06/27
 */

public class ParserFrameServiceImpl implements IParserFrameService<BaseJsonViewBean> {

    protected static ConcurrentHashMap<String, IDtuFrameParser> PARSER_CACHE = new ConcurrentHashMap<>(64);

    @SuppressWarnings("Duplicates")
    @Override
    public BaseJsonViewBean parserFrame(byte[] frameData) {
        BaseFrameParser baseFrameParser = new BaseFrameParser();
        BaseJsonViewBean communicate = baseFrameParser.baseParser(frameData);
        if (communicate == null) {
            return null;
        }
        communicate.setEquipmentNo(0);
        communicate.setSn(0);
        IDtuFrameParser parser;
        switch (communicate.getFunctionWord()) {
            case DtuProtocolConfig.CODE_LOGIN:
                parser = new LoginParser();
                List<BaseJsonViewBean.DataItemDTO> loginDto = parser.parserDataItem(DtuProtocolConfig.CODE_LOGIN, baseFrameParser.getDataBodyBody());
                communicate.setEquipmentNo(0);
                communicate.setDataItems(loginDto);
                break;
            case DtuProtocolConfig.CODE_BATTERY_LOGIN:
                parser = new BatteryLoginParser();
                List<BaseJsonViewBean.DataItemDTO> batteryLoginDto = parser.parserDataItem(DtuProtocolConfig.CODE_BATTERY_LOGIN, baseFrameParser.getDataBodyBody());
                communicate.setEquipmentNo(0);
                communicate.setDataItems(batteryLoginDto);
                break;
            case DtuProtocolConfig.CODE_HEART_BEAT:
                IDtuFrameParser hbParser = new HeartBeatParser();
                List<BaseJsonViewBean.DataItemDTO> hbItem = hbParser.parserDataItem(DtuProtocolConfig.CODE_HEART_BEAT, baseFrameParser.getDataBodyBody());
                communicate.setDataItems(hbItem);
                break;
            case DtuProtocolConfig.CODE_POLL_REQUEST_CMD:
                parser = new PollRequest87();
                List<BaseJsonViewBean.DataItemDTO> poll = parser.parserDataItem(DtuProtocolConfig.CODE_POLL_REQUEST_CMD, baseFrameParser.getDataBodyBody());
                communicate.setDataItems(poll);
                return CopyUtil.toBatteryBean(communicate);
            case DtuProtocolConfig.CODE_WRITE_RESP:
            case DtuProtocolConfig.CODE_READ_RESP:
            case DtuProtocolConfig.CODE_REPORT:
                communicate = parserBody(communicate, baseFrameParser.getDataBodyBody(), communicate.getFunctionWord());
                break;
            default:
                break;
        }
        return communicate;
    }

    private BaseJsonViewBean parserBody(BaseJsonViewBean communicate, byte[] dataBody, int funCode) {
        int pos = 0;
        int sn = HexUtil.byteArrayToInt(Arrays.copyOf(dataBody, DtuProtocolConfig.DTU_MSG_FLOW_LEN));
        pos += DtuProtocolConfig.DTU_MSG_FLOW_LEN;
        int equipmentNo = HexUtil.byteArrayToInt(Arrays.copyOfRange(dataBody, pos, pos + DtuProtocolConfig.DTU_EQUIPMENT_NO_LEN));
        pos += DtuProtocolConfig.DTU_EQUIPMENT_NO_LEN;
        byte[] dataStatus = Arrays.copyOfRange(dataBody, pos, dataBody.length);

        communicate.setSn(sn);
        communicate.setEquipmentNo(equipmentNo);

        if (dataStatus.length < DtuProtocolConfig.DTU_INFO_ID_LEN) {
            return communicate;
        }
        List<BaseJsonViewBean.DataItemDTO> dataItemDTOS = parserItemData(dataStatus, funCode);
        communicate.setDataItems(dataItemDTOS);
        return communicate;
    }

    private List<BaseJsonViewBean.DataItemDTO> parserItemData(byte[] dataStatus, int funCode) {

        int pos = 0;
        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>();

        IDtuFrameParser parser;

        while (pos < dataStatus.length) {
            int dataType = HexUtil.byteArrayToInt(Arrays.copyOfRange(dataStatus, pos, pos + DtuProtocolConfig.DTU_INFO_ID_LEN));
            pos += DtuProtocolConfig.DTU_INFO_ID_LEN;
            byte[] data;
            parser = this.findClass(funCode, dataType);

            if (parser == null) {
                continue;
            }

            int dataLen = parser.getCurrentCodeLength();
            if (dataLen == -1) {
                data = Arrays.copyOfRange(dataStatus, pos, dataStatus.length);
            } else {
                data = Arrays.copyOfRange(dataStatus, pos, pos + dataLen);
            }
            pos += data.length;

            List<BaseJsonViewBean.DataItemDTO> dataItemDTOList = parser.parserDataItem(dataType, data);
            if (dataItemDTOList == null) {
                // fix 2019年3月13日
                list.addAll(Collections.emptyList());
            } else {
                list.addAll(dataItemDTOList);
            }
        }
        return list;
    }

    private IDtuFrameParser findClass(int funCode, Object type) {
        switch (funCode) {
            case DtuProtocolConfig.CODE_REPORT:
                return newParserInstance(ReportData.class.getName(), type);
            case DtuProtocolConfig.CODE_WRITE_RESP:
                IDtuFrameParser parser = newParserInstance(WriteData.class.getName(), type);
                if (parser == null) {
                    parser = new WriteDataCommon();
                }
                return parser;
            case DtuProtocolConfig.CODE_READ_RESP:
                return newParserInstance(ReadData.class.getName(), type);
            default:
                return null;
        }
    }

    /**
     * 反射生成一个实例
     *
     * @param baseName
     * @param name
     * @return
     */
    private IDtuFrameParser newParserInstance(String baseName, Object name) {
        String cn = baseName + name.toString();
        IDtuFrameParser parser = PARSER_CACHE.get(cn);
        if (parser != null) {
            return parser;
        }
        try {
            Class<?> clazz = Class.forName(cn);
            parser = (IDtuFrameParser) clazz.newInstance();
            PARSER_CACHE.put(cn, parser);
            return parser;
        } catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * may be other 实现
     *
     * @param parserCache
     */
    public static void setParserCache(ConcurrentHashMap<String, IDtuFrameParser> parserCache) {
        PARSER_CACHE = parserCache;
    }
}
