package com.vcarecity.dtu.upload.read;

import com.vcarecity.allcommon.util.ArrayUtil;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/10/23
 * <p>
 * <p>
 * 0x020D	电池低电量报警阈值设置	4	W/R	Byte[2] 电量0%时的电压
 * Byte[2] 低电量报警时的电压
 * 电池电压单位：mV
 * 针对无线烟感的电池电压设置范围：1800mV-2700mV
 */

public class ReadData525 implements IDtuFrameParser {

    private static final String ZERO_PCT_V = "zeroPctV";
    private static final String LOW_PCT_V = "lowPctV";


    @Override
    public int getCurrentCodeLength() {
        return 4;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        Map<String, Object> hm = new HashMap<>(4);
        int zeroPctV = HexUtil.byteArrayToInt(ArrayUtil.copyTo(data, 0, 2));
        int lowPctV = HexUtil.byteArrayToInt(ArrayUtil.copyTo(data, 2, 2));


        hm.put(ZERO_PCT_V, String.valueOf(zeroPctV));
        hm.put(LOW_PCT_V, String.valueOf(lowPctV));

        hm.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));
        return parserOneDataItem(dataType, hm);
    }
}
