package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/12
 * <p>
 * 7e7e7e00000000000190000c0101010302010000001102018e
 * 7e7e7e0000000000019000180101010302030000001102010000001203000000001304019f
 */
public class ReadData770 implements IDtuFrameParser {
    private static final String ADDRESS = "address";
    private static final String PROPERTIES = "properties";

    @Override
    public int getCurrentCodeLength() {
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        int pos = 0;
        int dataCnt = HexUtil.byteArrayToInt(Arrays.copyOf(data, 1));
        if (dataCnt == 0) {
            dataCnt = 1;
        }
        pos += 1;
        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>();
        for (int i = 0; i < dataCnt; i++) {
            byte[] addressByte = Arrays.copyOfRange(data, pos, pos + 4);
            pos += addressByte.length;

            byte[] propertiesByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += propertiesByte.length;

            byte[] stateByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += stateByte.length;

            BaseJsonViewBean.DataItemDTO dto = new BaseJsonViewBean.DataItemDTO();
            dto.setId(dataType);

            HashMap<String, Object> hashMap = new HashMap<>(4);

            hashMap.put(ADDRESS, HexUtil.byteArrayToHex(addressByte));
            hashMap.put(PROPERTIES, String.valueOf(HexUtil.byteArrayToInt(propertiesByte)));
            hashMap.put(DtuProtocolJsonConstant.STATE, String.valueOf(HexUtil.byteArrayToInt(stateByte)));

            hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));


            dto.setData(hashMap);

            list.add(dto);
        }
        return list;
    }
}
