package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/12
 * <p>
 * 7e7e7e4442832e833c90000601010103070186
 */
public class ReadData775 implements IDtuFrameParser {
    private static final String POWER_SWITCH = "powerSwitch";

    @Override
    public int getCurrentCodeLength() {
        return 1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        HashMap<String, Object> hashMap = new HashMap<>(2);

        hashMap.put(POWER_SWITCH, String.valueOf(HexUtil.byteArrayToInt(data)));
        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));

        return this.parserOneDataItem(dataType, hashMap);
    }
}
