package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/06/27
 * <p>
 * 7e7e7e0000000000019000070101010311010084
 */

public class ReadData785 implements IDtuFrameParser {

    private static final String LINE_NO = "lineNo";
    private static final String THRESHOLD = "threshold";

    @Override
    public int getCurrentCodeLength() {
        return 2;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        System.out.println("ReadData785.parserDataItem");
        int lineNo = HexUtil.byteArrayToInt(Arrays.copyOf(data, 1));
        int threshold = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, 1, 2));
        HashMap<String, Object> hashMap = new HashMap<>(4);
        hashMap.put(LINE_NO, String.valueOf(lineNo));
        hashMap.put(THRESHOLD, String.valueOf(threshold));
        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));
        return this.parserOneDataItem(dataType, hashMap);
    }
}
