package com.vcarecity.dtu.upload.read;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuCmdStatus;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.vcarecity.dtu.constant.CmdConstantKey.ALARM_LOWER_LIMIT;
import static com.vcarecity.dtu.constant.CmdConstantKey.ALARM_UPPER_LIMIT;

/**
 * @author Kerry on 18/08/03
 * <p>
 * 设置液压压力值（适用于ZC9000H）	4	R/W	阈值高位在前，低位在后，单位kpa，范围0-3000kpa
 * Byte[2]:液压告警上限值  +
 * Byte[2]:液压告警下限值
 */

public class ReadData789 implements IDtuFrameParser {
    @Override
    public int getCurrentCodeLength() {
        return 4;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        int upper = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, 0, 2));
        int lower = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, 2, 4));

        Map<String, Object> hashMap = new HashMap<>(4);

        hashMap.put(ALARM_UPPER_LIMIT, String.valueOf(1.0 * upper / 1000.0));
        hashMap.put(ALARM_LOWER_LIMIT, String.valueOf(1.0 * lower / 1000.0));

        hashMap.put(DtuProtocolJsonConstant.RET, String.valueOf(DtuCmdStatus.CMD_RES_SUCCESS));

        return this.parserOneDataItem(dataType, hashMap);
    }
}
