package com.vcarecity.dtu.upload.report;




import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 * 0400
 * <p>
 * 7e7e7e000000000001b0000c000101040018041118181801ad
 */

public class ReportData1024 implements IDtuFrameParser {

    @Override
    public int getCurrentCodeLength() {
        return 6 + 1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        String dateTime = HexUtil.byteArrayToHex(Arrays.copyOf(data, 6));
        int state = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, 6, data.length));

        HashMap<String, Object> hashMap = new HashMap<>(2);

        hashMap.put(DtuProtocolJsonConstant.DATE_TIME, dateTime);
        hashMap.put(DtuProtocolJsonConstant.STATE, String.valueOf(state));

        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, hashMap));
    }
}
