package com.vcarecity.dtu.upload.report;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.*;

/**
 * @author Kerry on 18/04/11
 * <p>
 * 7e7e7e000000000001b0000d00010105021804111818180011bf
 */

public class ReportData1282 implements IDtuFrameParser {
    private static final String ALARM_FLAG = "alarmFlag";

    @Override
    public int getCurrentCodeLength() {
        //6+2
        return 6 + 2;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
        pos += dateTimeByte.length;
        byte[] alarmFlagByte = Arrays.copyOfRange(data, pos, pos + 2);

        Map<String, Object> hashMap = new HashMap<>(2);

        hashMap.put(ALARM_FLAG, String.valueOf(HexUtil.byteArrayToInt(alarmFlagByte)));
        hashMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));

        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, hashMap));
    }
}
