package com.vcarecity.dtu.upload.report;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/04/11
 * <p>
 * 反射用到
 */

public class ReportData1794 implements IDtuFrameParser {

    private static final String INDICATION = "indication";
    private static final String ALARM_FLAG = "alarmFlag";


    @Override
    public int getCurrentCodeLength() {
        //6 + 2 + 1
        return 6 + 2 + 1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;

        byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
        pos += dateTimeByte.length;

        byte[] indicationByte = Arrays.copyOfRange(data, pos, pos + 2);
        pos += indicationByte.length;

        byte[] alarmFlagByte = Arrays.copyOfRange(data, pos, pos + 1);
        pos += alarmFlagByte.length;

        HashMap<String, Object> hashMap = new HashMap<>(4);

        hashMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));
        hashMap.put(INDICATION, String.valueOf(HexUtil.byteArrayToInt(indicationByte)));
        hashMap.put(ALARM_FLAG, String.valueOf(HexUtil.byteArrayToInt(alarmFlagByte)));

        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, hashMap));
    }
}
