package com.vcarecity.dtu.upload.report;


import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/08/03
 */

public class ReportData1809 implements IDtuFrameParser {

    /**
     * 信号强度
     */
    private static final String SIGNAL_STRENGTH = "signalStrength";
    private static final String LOW_BATTERY_EVENT = "lowBatteryEvent";
    private static final String LIQUID_OVER_EVENT = "liquidOverEvent";
    private static final String TEMPERATURE = "temperature";
    private static final String HYDRAULIC = "hydraulic";
    private static final String PERCENT = "percent";


    @Override
    public int getCurrentCodeLength() {
        return -1;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int ss = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, 0, 1));
        int pos = 1;

        int count = HexUtil.byteArrayToInt(Arrays.copyOfRange(data, pos, pos + 1));
        pos += 1;

        List<BaseJsonViewBean.DataItemDTO> list = new ArrayList<>(count);

        for (int i = 0; i < count; i++) {

            byte[] dateTimeByte = Arrays.copyOfRange(data, pos, pos + 6);
            pos += dateTimeByte.length;

            byte[] batteryAlarmFlagByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += batteryAlarmFlagByte.length;

            byte[] liquidAlarmFlagByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += liquidAlarmFlagByte.length;

            byte[] temperatureByte = Arrays.copyOfRange(data, pos, pos + 2);
            pos += temperatureByte.length;

            byte[] liquidByte = Arrays.copyOfRange(data, pos, pos + 2);
            pos += liquidByte.length;

            byte[] percentageByte = Arrays.copyOfRange(data, pos, pos + 1);
            pos += percentageByte.length;

            HashMap<String, Object> dataMap = new HashMap<>(8);

            dataMap.put(SIGNAL_STRENGTH, String.valueOf(ss));
            dataMap.put(DtuProtocolJsonConstant.DATE_TIME, HexUtil.byteArrayToHex(dateTimeByte));

            dataMap.put(LOW_BATTERY_EVENT, String.valueOf(HexUtil.byteArrayToInt(batteryAlarmFlagByte)));
            dataMap.put(LIQUID_OVER_EVENT, String.valueOf(HexUtil.byteArrayToInt(liquidAlarmFlagByte)));
            //FIXME 要除吗?
            ///dataMap.put(TEMPERATURE, String.valueOf(1.0 * HexUtil.byteArrayToInt(temperatureByte) / 10.0));
            dataMap.put(TEMPERATURE, String.valueOf(HexUtil.byteArrayToInt(temperatureByte)));
            //FIXME 要除吗?
            ///dataMap.put(HYDRAULIC, String.valueOf(1.0 * HexUtil.byteArrayToInt(liquidByte) / 1000.0));
            dataMap.put(HYDRAULIC, String.valueOf(HexUtil.byteArrayToInt(liquidByte)));
            dataMap.put(PERCENT, String.valueOf(HexUtil.byteArrayToInt(percentageByte)));

            list.add(new BaseJsonViewBean.DataItemDTO(dataType, dataMap));

        }
        return list;
    }
}
