package com.vcarecity.dtu.upload.report;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;


/**
 * @author Kerry on 18/04/11
 * <p>
 * 反射用到
 */

public class ReportData384 implements IDtuFrameParser {

    private static final String FONT_LIB_TYPE = "fontLibType";
    private static final String F_CHAR = "char";
    private static final String DOT_ARRAY = "dotArray";

    @Override
    public int getCurrentCodeLength() {
        return 1 + 1 + 16;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {
        int pos = 0;
        byte[] fontLibType = Arrays.copyOfRange(data, pos, 1);
        pos += fontLibType.length;
        byte[] fChar = Arrays.copyOfRange(data, pos, 1);
        pos += fChar.length;
        byte[] dotArray = Arrays.copyOfRange(data, pos, 16);

        HashMap<String, Object> hashMap = new HashMap<>(4);

        hashMap.put(FONT_LIB_TYPE, fontLibType);
        hashMap.put(F_CHAR, fChar);
        hashMap.put(DOT_ARRAY, dotArray);

        return this.parserOneDataItem(dataType, hashMap);
    }
}
