package com.vcarecity.dtu.upload.write;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolJsonConstant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author Kerry on 18/06/08
 * <p>
 * 020c TCP嵌入升级的下发指令
 */

public class WriteData524 implements IDtuFrameParser {

    private static final String UPGRADE_VERSION = "version";

    @Override
    public int getCurrentCodeLength() {
        return 1 + 20;
    }

    @Override
    public List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data) {

        byte[] result = Arrays.copyOf(data, 1);
        byte[] version = Arrays.copyOfRange(data, 1, 21);


        HashMap<String, Object> hashMap = new HashMap<>(4);

        hashMap.put(DtuProtocolJsonConstant.RET, HexUtil.byteArrayToIntToString(result));
        hashMap.put(UPGRADE_VERSION, HexUtil.byteToString(version));

        return parserOneDataItem(dataType, hashMap);
    }
}
