/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.dtu.issued.write;

import com.vcarecity.allcommon.exception.DataTooLongException;
import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import java.util.Map;

public class IssuedWrite524
extends AbstractConverter {
    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object ip = data.get("ip");
        if (ip == null) {
            throw new NoRequireKeyException("ip");
        }
        byte[] ipByte = ip.toString().trim().getBytes();
        if (ipByte.length > 30) {
            throw new DataTooLongException("IP");
        }
        Object port = data.get("port");
        if (port == null) {
            throw new NoRequireKeyException("port");
        }
        int intPort = Integer.parseInt(port.toString());
        Object filename = data.get("filename");
        if (filename == null) {
            throw new NoRequireKeyException("filename");
        }
        byte[] filenameByte = filename.toString().trim().getBytes();
        if (filenameByte.length > 32) {
            throw new DataTooLongException("filename");
        }
        Object password = data.get("password");
        String pw = password != null ? password.toString() : "";
        byte[] pwByte = pw.trim().getBytes();
        if (pwByte.length > 16) {
            throw new DataTooLongException("password");
        }
        byte[] fixIp = new byte[30];
        System.arraycopy(ipByte, 0, fixIp, 30 - ipByte.length, ipByte.length);
        byte[] portByte = HexUtil.intToByteArray((int)intPort, (int)2);
        byte[] fixFilename = new byte[32];
        System.arraycopy(filenameByte, 0, fixFilename, 32 - filenameByte.length, filenameByte.length);
        byte[] fixPassword = new byte[16];
        System.arraycopy(pwByte, 0, fixPassword, 0, pwByte.length);
        return HexUtil.concatAll((byte[][])new byte[][]{fixIp, portByte, fixFilename, fixPassword});
    }
}

