package com.vcarecity.dtu.issued.read;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/05/10
 * <p>
 * <p>
 * 设置电气火灾探测器漏电告警值
 * <p>
 * 第1个字节为线路号，后两个字节为告警阈值，范围0-1000mA（0x0000-0x03E8），真实值高于此值会告警
 */

public class IssuedRead784 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        if (data == null) {
            throw new NoRequireKeyException("data");
        }
        Object lineNo = data.get("lineNo");
        if (lineNo == null) {
            throw new NoRequireKeyException("lineNo");
        }
        return HexUtil.intToByteArray(Integer.parseInt(lineNo.toString()), 1);
    }
}
