package com.vcarecity.dtu.issued.write;




import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 终端上行通信参数，包含APN+IP+PORT/;
 * 0201
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test513()
 */
@Deprecated
public class IssuedWrite513 extends AbstractConverter {

    private static final String APN = "apn";
    private static final String IP = "ip";
    private static final String PORT = "port";


    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object apn = data.get(APN);
        if (apn == null) {
            throw new NoRequireKeyException(APN);
        }
        Object ip = data.get(IP);
        if (ip == null) {
            throw new NoRequireKeyException(IP);
        }
        Object port = data.get(PORT);
        if (port == null) {
            throw new NoRequireKeyException(PORT);
        }

        return HexUtil.concatAll(
                HexUtil.strToByte(apn.toString(), 16),
                HexUtil.strToByte(ip.toString(), 30),
                HexUtil.intToByteArray(port.toString(), 2)
        );
    }

}
