package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 终端调试信息输出级别
 * 0208
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test520()
 */

public class IssuedWrite520 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object level = data.get("level");
        if (level == null) {
            throw new NoRequireKeyException("level");
        }
        Object password = data.get("password");
        if (password == null) {
            throw new NoRequireKeyException("password");
        }
        return HexUtil.concatAll(HexUtil.intToByteArray(level.toString(), 1),
                HexUtil.strToByte(password.toString(), 8));
    }

}
