package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 修改信息输出密码
 * 0209
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test521()
 */

public class IssuedWrite521 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object level = data.get("level");
        if (level == null) {
            throw new NoRequireKeyException("level");
        }

        Object origPass = data.get("origPass");
        if (origPass == null) {
            throw new NoRequireKeyException("origPass");
        }
        Object newPass = data.get("newPass");
        if (newPass == null) {
            throw new NoRequireKeyException("newPass");
        }

        Object reNewPass = data.get("reNewPass");
        if (reNewPass == null) {
            throw new NoRequireKeyException("reNewPass");
        }

        return HexUtil.concatAll(
                HexUtil.intToByteArray(level.toString(), 1),
                HexUtil.strToByte(origPass.toString(), 8),
                HexUtil.strToByte(newPass.toString(), 8),
                HexUtil.strToByte(reNewPass.toString(), 8));
    }

}
