package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 设置测量点参数
 * 数据长度+(测量点地址+性质+状态)
 * 0302
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test770()
 */

public class IssuedWrite770 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {

        Object address = data.get("address");
        if (address == null) {
            throw new NoRequireKeyException("address");
        }
        Object properties = data.get("properties");
        if (properties == null) {
            throw new NoRequireKeyException("properties");
        }
        Object state = data.get("state");
        if (state == null) {
            throw new NoRequireKeyException("state");
        }
        //dataCnt + address + properties + state
        return HexUtil.concatAll(
                HexUtil.intToByteArray(0, 1),
                HexUtil.hexToByteArray(address.toString(), 4),
                HexUtil.intToByteArray(properties.toString(), 1),
                HexUtil.intToByteArray(state.toString(), 1));
    }

}
