package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 测量点地址
 * 0303
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test771()
 */

public class IssuedWrite771 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object address = data.get("address");
        if (address == null) {
            throw new NoRequireKeyException("address");
        }
        String string = address.toString();
        if (string.length() == 1) {
            string = "0" + string;
        } else if (string.length() == 0) {
            string = "00";
        }
        return HexUtil.hexToByteArray(string, 1);
    }

}
