package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/13
 * 0305
 * <p>
 * 设置主机测量点参数
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test773()
 */

public class IssuedWrite773 extends AbstractConverter {
    private static final String DATA_CONTENT = "dataContent";


    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object dataContent = data.get(DATA_CONTENT);
        if (dataContent == null) {
            throw new NoRequireKeyException(DATA_CONTENT);
        }

        return HexUtil.hexToByteArray(dataContent.toString());
    }

}
