package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 气体传感器电源开关控制，适用于ZC9000S
 * 0307
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test775()
 */

public class IssuedWrite775 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object powerSwitch = data.get("powerSwitch");
        if (powerSwitch == null) {
            throw new NoRequireKeyException("powerSwitch");
        }
        return HexUtil.intToByteArray(powerSwitch.toString(), 1);
    }

}
