package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 气体传感器告警关闭电源超时值，适用于ZC9000S
 * 0308
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test776()
 */

public class IssuedWrite776 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object period = data.get("period");
        if (period == null) {
            throw new NoRequireKeyException("period");
        }
        return HexUtil.intToByteArray(period.toString(), 2);
    }

}
