package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * 设备告警触发重置
 * 030A
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test778()
 */

public class IssuedWrite778 extends AbstractConverter {

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object alarmReset = data.get("alarmReset");
        if (alarmReset == null) {
            throw new NoRequireKeyException("alarmReset");
        }
        return HexUtil.intToByteArray(alarmReset.toString(), 1);
    }

}
