package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 设置电气火灾探测器温度告警值
 * 0311
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test785()
 */

public class IssuedWrite785 extends AbstractConverter {

    private static final String LINE_NO = "lineNo";
    private static final String THRESHOLD = "threshold";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object ln = data.get(LINE_NO);
        if (ln == null) {
            throw new NoRequireKeyException(LINE_NO);
        }
        Object th = data.get(THRESHOLD);
        if (th == null) {
            throw new NoRequireKeyException(THRESHOLD);
        }
        return HexUtil.concatAll(HexUtil.intToByteArray(ln.toString(), 1),
                HexUtil.intToByteArray(th.toString(), 1));
    }

}
