package com.vcarecity.dtu.issued.write;


import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/13
 * <p>
 * 0313
 * 删除测量点
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test787()
 */

public class IssuedWrite787 extends AbstractConverter {

    private static final String PROPERTIES = "properties";
    private static final String ADDRESS = "address";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object properties = data.get(PROPERTIES);
        if (properties == null) {
            throw new NoRequireKeyException(PROPERTIES);
        }
        Object address = data.get(ADDRESS);
        if (address == null) {
            throw new NoRequireKeyException(ADDRESS);
        }
        byte[] pb = HexUtil.intToByteArray(properties, 1);
        byte[] ab = HexUtil.hexToByteArray(address.toString(), 4);
        return HexUtil.concatAll(pb, ab);
    }

}
