package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;

import java.util.Map;

/**
 * @author Kerry on 18/04/16
 * <p>
 * 设置告警开关
 * 0314
 * <p>
 * com.vcarecity.nb.north.service.IssuedDataHandlerServiceTest#test788()
 */

public class IssuedWrite788 extends AbstractConverter {

    private static final String ALARM_SWITCH = "alarmSwitch";

    @Override
    public byte[] convertItemBody(Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object as = data.get(ALARM_SWITCH);
        if (as == null) {
            throw new NoRequireKeyException(ALARM_SWITCH);
        }
        return HexUtil.intToByteArray(as.toString(), 2);
    }

}
