package com.vcarecity.dtu.issued.write;



import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtu.service.AbstractConverter;
import org.jetbrains.annotations.NotNull;

import java.math.BigDecimal;
import java.util.Map;

import static com.vcarecity.dtu.constant.CmdConstantKey.ALARM_LOWER_LIMIT;
import static com.vcarecity.dtu.constant.CmdConstantKey.ALARM_UPPER_LIMIT;

/**
 * @author Kerry on 18/08/03
 * <p>
 * 设置液压压力值（适用于ZC9000H）	4	R/W	阈值高位在前，低位在后，单位kpa，范围0-3000kpa
 * Byte[2]:液压告警上限值  +
 * Byte[2]:液压告警下限值
 */

public class IssuedWrite789 extends AbstractConverter {

    @NotNull
    @Override
    public byte[] convertItemBody(@NotNull Integer id, Map<String, Object> data) throws NoRequireKeyException {
        Object alarmUpper = data.get(ALARM_UPPER_LIMIT);
        if (alarmUpper == null) {
            throw new NoRequireKeyException(ALARM_UPPER_LIMIT);
        }
        Object alarmLower = data.get(ALARM_LOWER_LIMIT);
        if (alarmLower == null) {
            throw new NoRequireKeyException(ALARM_LOWER_LIMIT);
        }

        BigDecimal upper = new BigDecimal(alarmUpper.toString()).multiply(new BigDecimal(1000));
        BigDecimal lower = new BigDecimal(alarmLower.toString()).multiply(new BigDecimal(1000));


        return HexUtil.concatAll(HexUtil.intToByteArray(upper.intValue(), 2),
                HexUtil.intToByteArray(lower.intValue(), 2));
    }
}
