package com.vcarecity.dtu.parser;


import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.util.CrcUtil;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

/**
 * @author Kerry on 18/06/27
 */

public class BaseFrameParser {
    private static Logger logger = LoggerFactory.getLogger(BaseFrameParser.class);

    private byte[] dataBodyBody;

    public BaseJsonViewBean baseParser(byte[] frameData) {
        int pos = 0;
        //标识头
        byte[] maskByte = Arrays.copyOf(frameData, DtuProtocolConfig.DTU_MASK_LEN);

        if (!Arrays.equals(DtuProtocolConfig.DTU_MASK, maskByte)) {
            logger.debug("frame mask not equals 7e7e7e,data=[{}]", HexUtil.byteArrayToHex(frameData));
            return null;
        }
        pos += maskByte.length;

        //设备地址
        byte[] deviceIdByte = Arrays.copyOfRange(frameData, pos, pos + DtuProtocolConfig.DTU_DEVICE_ID_LEN);
        pos += deviceIdByte.length;

        //功能码
        byte[] funCodeByte = Arrays.copyOfRange(frameData, pos, pos + DtuProtocolConfig.DTU_FUNC_LEN);
        pos += funCodeByte.length;
        int funCode = HexUtil.byteArrayToInt(funCodeByte);

        //数据长度
        byte[] dateLenByte = Arrays.copyOfRange(frameData, pos, pos + DtuProtocolConfig.DTU_LEN_LEN);
        pos += dateLenByte.length;
        //数据长度10进制
        int dataLen = HexUtil.byteArrayToInt(dateLenByte);

        // 检查帧中定义的长度和实际的数据长度是否一致.
        if (pos + dataLen + DtuProtocolConfig.DTU_CRC_LEN != frameData.length) {
            logger.debug("frame error,please check frame length and actual length,data=[{}]", HexUtil.byteArrayToHex(frameData));
            return null;
        }
        dataBodyBody = Arrays.copyOfRange(frameData, pos, pos + dataLen);
        pos += dataBodyBody.length;

        int crcCode = HexUtil.byteArrayToInt(Arrays.copyOfRange(frameData, pos, pos + DtuProtocolConfig.DTU_CRC_LEN));

        int calcCrcCode = HexUtil.byteToInt(CrcUtil.validate(frameData, maskByte.length, pos));

        if (crcCode != calcCrcCode) {
            logger.debug("CRC ERROR,Calc={},data=[{}]", calcCrcCode, HexUtil.byteArrayToHex(frameData));
            return null;
        }

        BaseJsonViewBean communicate = new BaseJsonViewBean();
        communicate.setUnitNo(HexUtil.byteArrayToHex(deviceIdByte));
        communicate.setFunctionWord(funCode);
        communicate.setEnable(0);
        communicate.setEquipmentNo(0);

        return communicate;
    }

    public byte[] getDataBodyBody() {
        return dataBodyBody;
    }
}
