package com.vcarecity.dtu.response;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.dtu.constant.Constants;
import com.vcarecity.dtu.service.AbstractConverter;
import org.jetbrains.annotations.NotNull;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 19/01/03
 * <p>
 * <p>
 * 0x06	登录（长时间休眠设备使用）	上行：22
 * 下行：8		上行：
 * String[20] CCID号 +
 * Byte[2] 电池电量，单位%
 * 下行：
 * byte[6]: 时间 +
 * word: 平台缓存的指令数量
 * <p>
 * <p>
 * <p>
 * ------------------
 * 注意: 由于要多加一个外面参数,要传过来,所在这个参数目前放在SN字段,由于登录时用不到这个字段
 */

public class BatteryLoginResponse extends AbstractConverter {

    public static final String CACHE_COUNT = "cacheCount";

    /**
     * 没有消息流水,测量点
     *
     * @param sn
     * @param equipmentNo
     * @return
     */
    @Override
    public byte[] customSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        return new byte[0];
    }

    @NotNull
    @Override
    public byte[] convertItemBody(@NotNull Integer id, Map<String, Object> data) throws NoRequireKeyException {
        //Login not input here
        return new byte[0];
    }


    /**
     * 强制返回当前时间
     *
     * @param sn
     * @param equipmentNo
     * @param list
     * @return
     * @throws NoRequireKeyException
     */
    @Override
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {
        String currentTime = LocalDateTime.now().format(Constants.DATE_TIME_FORMATTER);

        int count = 0;
        if (sn != null) {
            count = sn;
        }
        return HexUtil.concatAll(HexUtil.hexToByteArray(currentTime), HexUtil.intToByteArray(count, 2));
    }

}
